/**
 *
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.ExportHolderImpl;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.io.exportFormats.ExportFormat;

import CH.ifa.draw.util.Iconkit;

import de.renew.plugin.command.CLCommand;

import java.awt.Frame;

import java.io.File;
import java.io.PrintStream;


/**
 * @author Lawrence Cabac
 *
 */
public class ExportClCommand implements CLCommand, StatusDisplayer {
    private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                        .getLogger(ExportClCommand.class);

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#execute(java.lang.String[], java.io.PrintStream)
     */
    public void execute(String[] args, PrintStream response) {
        //initialize Iconkit if not done already.
        if (Iconkit.instance() == null) {
            new Iconkit(new Frame());
        }
        ExportHolderImpl exporter = (ExportHolderImpl) DrawPlugin.getCurrent()
                                                                 .getExportHolder();
        ExportFormat[] formats = exporter.allExportFormats();

        if (args.length >= 2) {
            String type = args[0];

            ExportFormat format = new EPSExportFormat();
            for (int i = 0; i < formats.length; i++) {
                logger.debug(formats[i]);
                if (formats[i].formatName().toLowerCase()
                                      .equals(type.toLowerCase())) {
                    format = formats[i];
                    logger.info(ExportClCommand.class.getName()
                                + ": format is " + format.formatName());
                    // if it's a SimpleFileFilter use the defined extenstion
                    if (format.fileFilter() instanceof SimpleFileFilter) {
                        type = ((SimpleFileFilter) format.fileFilter())
                                   .getExtension();
                    }
                    break; // we found our format
                }
            }

            for (int i = 1; i < args.length; i++) {
                String filename = args[i];
                logger.info(ExportClCommand.class.getName() + ": filename is "
                            + filename);
                File file = new File(filename);
                if (file.exists()) {
                    // TODO this is how to load drawing programmatically
                    Drawing drawing = DrawingFileHelper.loadDrawing(file, this);
                    logger.info(ExportClCommand.class.getName()
                                + ": drawing is " + drawing.getName());
                    File path = new File(drawing.getFilename().getAbsoluteFile()
                                                .getParentFile(),
                                         drawing.getName() + "." + type);
                    logger.info(ExportClCommand.class.getName() + ": path is "
                                + path);
                    exporter.saveDrawing(drawing, format, path, this);
                }
            }
        }
    }

    /* (non-Javadoc)
     * @see de.renew.plugin.command.CLCommand#getDescription()
     */
    public String getDescription() {
        return "Exports a drawing. Useage: ex <extension> <drawing> ";
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.io.StatusDisplayer#showStatus(java.lang.String)
     */
    public void showStatus(String message) {
        logger.info(ExportClCommand.class.getName() + " Status: " + message);
    }
}