/*
 * Created on Apr 26, 2003
 */
package de.renew.diagram.peer;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.FigureEnumeration;

import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StatusDisplayer;

import de.renew.diagram.PaletteCreatorPlugin;

import de.renew.io.RNWFileFilter;

import java.io.File;

import java.net.MalformedURLException;
import java.net.URL;


/**
 * This class allows to load a netcomponent during runtime from the tools directory.
 *
 * @author Lawrence Cabac
 */
public class NCLoader {
    public static org.apache.log4j.Logger logger = org.apache.log4j.Logger
                                                       .getLogger(NCLoader.class);
    static private NCLoader loader;
    static private String path = "";
    static private final StatusDisplayer sd = new StatusDisplayer() {
        public void showStatus(String string) {
            logger.info(string);
        }
    };

    private NCLoader() {
        super();
        String pluginLocation = PaletteCreatorPlugin.getLocation();
        logger.debug("Location " + pluginLocation);
        path = pluginLocation.substring(0, pluginLocation.lastIndexOf("/"))
               + "/tools/";
        path = path.substring(5, path.length());
    }

    static public NCLoader getInstance() {
        if (loader == null) {
            loader = new NCLoader();
        }
        return loader;
    }

    public FigureEnumeration getfigures(String string) {
        Drawing drawing = loadDrawing(string);
        logger.debug("Drawing : " + drawing);
        if (drawing == null) {
            return null;
        }
        return drawing.figures();
    }

    private Drawing loadDrawing(String string) {
        File file = DrawingFileHelper.checkAndAddExtension(new File(path, string),
                                                           new RNWFileFilter());
        URL url = null;
        try {
            url = new URL("file", "localhost", file.getAbsolutePath());
        } catch (MalformedURLException e1) {
            if (logger.isDebugEnabled()) {
                logger.debug(NCLoader.class.getSimpleName() + ": ", e1);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(NCLoader.class.getSimpleName()
                         + " Loading component: " + url.toString());
        }
        return DrawingFileHelper.loadDrawing(url, sd);
    }
}