package CH.ifa.draw.util;

import CH.ifa.draw.standard.MultiLineLabel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;


/**
 * MessageDialog: A utility class for building simple modal dialog windows
 * including a multi-line message text and a set of user buttons.
 *
 */
public class MessageDialog implements ActionListener {
    public final static int LEFT = 0;
    public final static int CENTER = 1;
    public final static String SPACE = "  ";
    public final static String DEFAULT_BUTTON_LABEL = " OK ";
    private JButton[] button;
    private JPanel buttonPanel;
    private JDialog alert;
    private int pressedButton;
    private int defaultButton;

    // Die Zeilen der MessageDialog werden als Felder eines String-Arrays ?bergeben.
    // z.B. MessageDialog a = new MessageDialog(this, "Titel", new String[] {"Zeile 1","Zweite Zeile"});
    // Aufruf mit Titel und Array
    MessageDialog(JFrame f, String title, String[] message) {
        this(f, title, message, DEFAULT_BUTTON_LABEL);
    }

    // Aufruf mit Titel, Array und einem Buttonlabel
    MessageDialog(JFrame f, String title, String[] message, String label) {
        this(f, title, message, CENTER, new String[] { label });
    }

    // Aufruf mit Titel, Array und Buttonlabels
    MessageDialog(JFrame f, String title, String[] message, String[] label) {
        this(f, title, message, CENTER, label);
    }

    // Aufruf mit allen Parametern auser defaultButton
    MessageDialog(JFrame f, String title, String[] message, int alignment,
                  String[] label) {
        this(f, title, message, alignment, label, 2);
    }

    // Aufruf mit allen Parametern
    MessageDialog(JFrame f, String title, String[] message, int alignment,
                  String[] label, int defButton) {
        defaultButton = defButton;

        alert = new JDialog(f, title, true);
        alert.getContentPane().setLayout(new BorderLayout());
        alert.setBackground(Color.lightGray);

        int alignmentValue = (alignment == LEFT) ? MultiLineLabel.LEFT
                                                 : MultiLineLabel.CENTER;
        StringBuffer messageLines = new StringBuffer();
        for (int i = 0; i < message.length; i++) {
            // Die Textzeilen als mehrzeiligen "Label" erzeugen. Font setzen.
            messageLines.append(SPACE);
            messageLines.append(message[i]);
            messageLines.append(SPACE);
            messageLines.append('\n');
        }
        MultiLineLabel l = new MultiLineLabel(messageLines.toString(),
                                              alignmentValue);
        l.setFont(Fontkit.getFont("SansSerif", Font.BOLD, 13));
        alert.getContentPane().add("Center", l);


        // Ein Panel f?r die Buttons, da sie zentriert werden sollen.
        buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());


        // Die Buttons
        button = new JButton[label.length];
        for (int i = 0; i < label.length; ++i) {
            button[i] = new JButton(label[i]);
            button[i].setActionCommand(String.valueOf(i));
            button[i].addActionListener(this);
            buttonPanel.add(button[i]);
        }


        /* endfor */
        alert.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e) {
                    pressedButton = defaultButton;
                    alert.setVisible(false); // Dialog entfernen
                }
            });


        // Das Panel hinzuf?gen
        alert.getContentPane().add("South", buttonPanel);
        alert.pack();
        if (!GUIProperties.avoidFrameReshape()) {
            alert.setLocation(330, 230);
        }
    }

    public static int invokeDialog(JFrame f, String title, String[] message,
                                   int alignment, String[] label) {
        return invokeDialog(f, title, message, alignment, label, 2);
    }

    public static int invokeDialog(JFrame f, String title, String[] message,
                                   int alignment, String[] label,
                                   int defaultButton) {
        MessageDialog md = new MessageDialog(f, title, message, alignment,
                                             label, defaultButton);
        md.invoke();
        md.alert.dispose();
        return md.pressedButton;
    }

    public int invoke() {
        pressedButton = defaultButton;
        alert.setVisible(true);
        // ...is automatically suspended until alert closed!
        return pressedButton;
    }

    // Wenn der OK-Button gedr?ckt wird, dann soll die Alert-Box geschlossen werden.
    public void actionPerformed(ActionEvent e) {
        // logger.debug("actionPerformed: "+e.getActionCommand());
        pressedButton = Integer.valueOf(e.getActionCommand()).intValue();
        alert.setVisible(false); // Dialog entfernen
    }

    public void windowClosed() {
        pressedButton = defaultButton;
        alert.setVisible(false); // Dialog entfernen
    }
}