package CH.ifa.draw.standard;

import org.apache.log4j.Logger;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.lang.reflect.Method;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * Generischer Textanzeigedialog mit OK-Button (modal)
 *
 * 05.10.2000 HR
 *
 */
public class InfoDialog extends JDialog {
    private Logger logger = Logger.getLogger(InfoDialog.class);
    protected JButton button;
    protected MultiLineLabel label;

    public InfoDialog(Frame parent, String title, String message) {
        super(parent, title, true);

        getContentPane().setLayout(new BorderLayout(15, 15));

        label = new MultiLineLabel(message, 20, 20);

        getContentPane().add("Center", label);

        button = new JButton("OK");
        ActionListener listener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                InfoDialog.this.dispose();
            }
        };
        button.addActionListener(listener);
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
        p.add(button);
        getContentPane().add("South", p);

        pack();
    }

    /**
     * Get InfoDialog with JLable
     *
     * @param title
     * @param parent
     * @param message
     */
    public InfoDialog(Frame parent, String title, String message,
                      boolean addRenewLink) {
        super(parent, title, true);

        try {
            getContentPane().setLayout(new BorderLayout(15, 15));
            JLabel jLabel = new JLabel("<html>" + message + "</html>");
            jLabel.setOpaque(true);

            JPanel aboutPanel = new JPanel();
            aboutPanel.setLayout(new BoxLayout(aboutPanel, BoxLayout.PAGE_AXIS));
            aboutPanel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 25));
            aboutPanel.add(jLabel);
            aboutPanel.add(Box.createRigidArea(new Dimension(0, 5)));
            if (addRenewLink) {
                aboutPanel = createLinkLabel(aboutPanel, "http://www.renew.de");
                aboutPanel = createLinkLabel(aboutPanel, "http://www.paose.net");
            }
            getContentPane().add("Center", aboutPanel);

            button = new JButton("OK");
            ActionListener listener = new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    InfoDialog.this.dispose();
                }
            };
            button.addActionListener(listener);
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
            p.add(button);
            getContentPane().add("South", p);

            pack();
        } catch (Exception e) {
            logger.error("InfoDialog " + e);
        }
    }

    private JPanel createLinkLabel(JPanel helpPanel, final String url) {
        JLabel paose = new JLabel("<html>See <a href=\"" + url + "\">" + url
                                  + "</a></html>");
        paose.setCursor(new Cursor(Cursor.HAND_CURSOR));
        paose.addMouseListener(new java.awt.event.MouseAdapter() {
                public void mouseClicked(java.awt.event.MouseEvent evt) {
                    if (evt.getClickCount() > 0) {
                        openURL(url);
                    }
                }
            });
        helpPanel.add(paose);
        return helpPanel;
    }

    private void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL",
                                                           new Class[] { String.class });
                openURL.invoke(null, new Object[] { url });
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime()
                       .exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else { // assume Unix or Linux
                String[] browsers = { "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape" };
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null;
                             count++) {
                    if (Runtime.getRuntime()
                                       .exec(new String[] { "which", browsers[count] })
                                       .waitFor() == 0) {
                        browser = browsers[count];
                    }
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[] { browser, url });
            }
        } catch (Exception e) {
        }
    }
}