/*
 * @(#)AlignCommand.java 5.1
 *
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.UndoableCommand;

import java.awt.Rectangle;


/**
 * Align a selection of figures relative to each other.
 */
public class AlignCommand extends UndoableCommand {

    /**
     * align left sides
     */
    public final static int LEFTS = 0;

    /**
     * align centers (horizontally)
     */
    public final static int CENTERS = 1;

    /**
     * align right sides
     */
    public final static int RIGHTS = 2;

    /**
     * align tops
     */
    public final static int TOPS = 3;

    /**
     * align middles (vertically)
     */
    public final static int MIDDLES = 4;

    /**
     * align bottoms
     */
    public final static int BOTTOMS = 5;

    // protected DrawingEditor fEditor;
    private int fOp;

    /**
     * Constructs an alignment command.
     * @param name the command name
     * @param op the alignment operation (LEFTS, CENTERS, RIGHTS, etc.)
     */
    public AlignCommand(String name, int op) {
        super(name);
        // fEditor = editor;
        fOp = op;
    }

    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        return getEditor().view().selectionCount() > 1;
    }

    public boolean executeUndoable() {
        if (isExecutable()) {
            if (!super.isExecutable()) {
                return false;
            }
            DrawingView view = getEditor().view();
            FigureEnumeration selection = view.selectionElements();
            Figure anchorFigure = selection.nextFigure();
            Rectangle r = anchorFigure.displayBox();

            while (selection.hasMoreElements()) {
                Figure f = selection.nextFigure();
                Rectangle rr = f.displayBox();
                switch (fOp) {
                case LEFTS:
                    f.moveBy(r.x - rr.x, 0);
                    break;
                case CENTERS:
                    f.moveBy((r.x + r.width / 2) - (rr.x + rr.width / 2), 0);
                    break;
                case RIGHTS:
                    f.moveBy((r.x + r.width) - (rr.x + rr.width), 0);
                    break;
                case TOPS:
                    f.moveBy(0, r.y - rr.y);
                    break;
                case MIDDLES:
                    f.moveBy(0, (r.y + r.height / 2) - (rr.y + rr.height / 2));
                    break;
                case BOTTOMS:
                    f.moveBy(0, (r.y + r.height) - (rr.y + rr.height));
                    break;
                }
            }
            view.checkDamage();
            return true;
        }
        return false;
    }
}