/*
 * Created on Apr 13, 2003
 */
package CH.ifa.draw.io;

import java.io.File;

import java.util.HashSet;
import java.util.Iterator;

import javax.swing.filechooser.FileFilter;


/**
 * @author Lawrence Cabac
 *
 * SimpleFileFilters can be combined into new combinations of FileFilters.
 * By adding SimpleFileFilters the Cmbination will filter all except for those listed.
 * CombinationFileFilter can be added to a new Combination but not to the same.
 * Beware of multiple linked recursions.
 */
public class CombinationFileFilter extends FileFilter implements java.io.FileFilter {
    private HashSet<SimpleFileFilter> filterList;
    private SimpleFileFilter preferedFileFilter;
    private String description;
    private boolean allowDirectory = true;
    private boolean allowHidden = false;

    public CombinationFileFilter(String description) {
        setDescription(description);
        filterList = new HashSet<SimpleFileFilter>();

    }

    private void setDescription(String description) {
        this.description = description;

    }

    // Same Filter should not be addable. fix!
    // Duplicate Filter should not be addable. fix!
    public boolean add(SimpleFileFilter ff) {
        boolean result = false;
        if (!contains(ff)) {
            if (filterList.isEmpty()) {
                preferedFileFilter = ff;
            }
            result = filterList.add(ff);
        }
        return result;
    }

    public boolean contains(SimpleFileFilter filter) {
        boolean result = false;
        Iterator<SimpleFileFilter> iter = filterList.iterator();
        while (iter.hasNext()) {
            SimpleFileFilter ff = iter.next();
            if (filter != null && filter.equals(ff)) {
                result = true;
            }
        }
        return result;
    }

    public void remove(SimpleFileFilter ff) {
        filterList.remove(ff);
    }

    public HashSet<SimpleFileFilter> getFileFilters() {
        return filterList;
    }

    public String getExtension() {
        return getPreferedFileFilter().getExtension();
    }

    public void allowHidden(boolean b) {
        allowHidden = b;
    }

    public void allowDirectory(boolean b) {
        allowDirectory = b;
    }

    public boolean isHiddenAllowed() {
        return allowHidden;
    }

    public boolean isDirectoryAllowed() {
        return allowDirectory;
    }

    /* (non-Javadoc)
     * @see javax.swing.filechooser.FileFilter#accept(java.io.File)
     */
    public boolean accept(File f) {
        if (f != null
                    && (allowHidden
                               || !f.isHidden() && !f.getName().startsWith("."))) {
            if (f.isDirectory()) {
                return allowDirectory;
            }

            Iterator<SimpleFileFilter> it = filterList.iterator();
            while (it.hasNext()) {
                if (it.next().accept(f)) {
                    return true;
                }
            }
        }
        return false;
    }

    public SimpleFileFilter getPreferedFileFilter() {
        return preferedFileFilter;
    }

    public void setPreferedFileFilter(SimpleFileFilter filter) {
        preferedFileFilter = filter;
    }

    public boolean isEmpty() {
        return filterList.isEmpty();
    }

    /* (non-Javadoc)
    * @see javax.swing.filechooser.FileFilter#getDescription()
    */
    public String getDescription() {
        return description;
    }
}