package CH.ifa.draw.framework;

import CH.ifa.draw.util.Storable;

import java.awt.Graphics;
import java.awt.Rectangle;

import java.io.Serializable;


/**
 * Interface for Decorations.
 * Decorations know how to draw themselves and nothing more.
 * They can be used to display additional information about
 * a certain Figure.
 * They can be added to {@link Decorable}s, but are not informed
 * about changes to the figure.
 *
 * @see LolaDecoration, LinkDecoration
 * @author hewelt
 *
 */
public interface Decoration extends Storable, Serializable {
    public void draw(Graphics g, Rectangle box);
}