package CH.ifa.draw.framework;

import java.awt.Graphics;

import java.util.List;


/**
 * Interface for Figure that can be decorated by adding
 * {@link Decoration}s to it.
 * Decorable figures keep track of their decorations.
 * They also call the draw method of their decorations,
 * after they have drawn themselves.
 *
 * @author Marcin Hewelt
 * @since 2.3
 *
 */
public interface Decorable {
    //public List<Decoration> fDecorations;

    /**
     * Adds a decoration to the list.
     */
    public void addDecoration(Decoration d);

    /**
     * Removes a decoration from the list.
     * @param d
     */
    public void removeDecoration(Decoration d);

    /**
     * Draw the existing decorations.
     */
    public void drawDecorations(Graphics g);

    /**
     * Checks whether a figure has decorations.
     */
    public boolean isDecorated();

    /**
     * Returns a list of decorations.
     */
    public List<Decoration> getDecorations();
}