package CH.ifa.draw.figures;

import CH.ifa.draw.DrawPlugin;

import CH.ifa.draw.application.DrawApplication;

import CH.ifa.draw.framework.Drawing;

import CH.ifa.draw.io.DrawingFileHelper;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;

import java.io.File;
import java.io.IOException;

import javax.swing.ImageIcon;


/**
 * A Decoration that holds a link and open this link in a new
 * window when it is clicked.
 *
 * @author hewelt
 */
public class LinkDecoration extends ClickableDecoration {
    private final static long serialVersionUID = 125012030821382479L;
    private File link;
    private static final String defaultIconFilename = "/CH/ifa/draw/images/LINKICON.gif";
    private static final ImageIcon defaultLinkIcon = initDefaultIcon(defaultIconFilename);

    /**
     * empty constructor required by {@link Storable}.
     */
    public LinkDecoration() {
        super();
    }

    public LinkDecoration(File link) {
        super(defaultLinkIcon);
        this.link = link;
    }

    public LinkDecoration(int x, int y, int orient, File link) {
        super(x, y, orient, defaultLinkIcon);
        this.link = link;
        //TODO check if link is valid
    }

    /**
     * Open link in new window.
     */
    public void clicked() {
        //IOHelper.getInstance().loadAndOpenDrawing(link);
        logger.info("[LinkDecoration] Trying to load link to " + link);
        DrawApplication gui = DrawPlugin.getGui();
        Drawing drawing = DrawingFileHelper.loadDrawing(link, gui);
        if (drawing != null && gui != null) {
            gui.openDrawing(drawing);
        } else {
            logger.error("[LinkDecoration] Either no gui or no drawing: ");
        }
    }

    private void setLink(String linkname) {
        link = new File(linkname);
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.figures.DecorationImpl#write(CH.ifa.draw.util.StorableOutput)
     */
    @Override
    public void write(StorableOutput dw) {
        super.write(dw);
        if (link != null) {
            dw.writeString(link.toString());
        }
    }

    /* (non-Javadoc)
     * @see CH.ifa.draw.figures.DecorationImpl#read(CH.ifa.draw.util.StorableInput)
     */
    @Override
    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        String linkString = dr.readString();
        logger.debug("[LinkDecoration] Read linkString " + linkString);
        link = new File(linkString);
    }
}