package CH.ifa.draw.figures;

import org.apache.log4j.Logger;

import CH.ifa.draw.framework.Decoration;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;

import de.renew.util.StringUtil;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import java.io.File;
import java.io.IOException;

import java.net.URI;
import java.net.URL;

import javax.swing.ImageIcon;


public class DecorationImpl implements Decoration {
    public static Logger logger = Logger.getLogger(DecorationImpl.class);
    private int xOffset;
    private int yOffset;
    private int orientation;
    private ImageIcon icon;
    protected int iconWidth;
    protected int iconHeight;
    public static final int TopLeftOrientation = 0;
    public static final int BottomLeftOrientation = 1;
    public static final int TopRightOrientation = 2;
    public static final int BottomRightOrientation = 3;
    private static final String defaultIconFilename = "/CH/ifa/draw/images/LINKICON.gif";
    private static final ImageIcon defaultIcon = initDefaultIcon(defaultIconFilename);

    public DecorationImpl() {
        this(0, 0, 0);
    }

    public DecorationImpl(int xOff, int yOff, int orient) {
        xOffset = xOff;
        yOffset = yOff;
        orientation = orient;
        setIcon(defaultIcon);
    }

    public DecorationImpl(int xOff, int yOff, int orient, ImageIcon ico) {
        this(xOff, yOff, orient);
        setIcon(ico);
    }

    public DecorationImpl(ImageIcon ico) {
        setIcon(ico);
    }

    protected static ImageIcon initDefaultIcon(String filename) {
        ImageIcon result = null;
        logger.info("[DecorationImpl.initDefaultIcon] filename is " + filename);
        URL defaultIconUrl = DecorationImpl.class.getResource(filename);
        if (defaultIconUrl == null) {
            logger.error("[Decoration] Could not find default icon");
        } else {
            result = new ImageIcon(defaultIconUrl);
        }
        return result;
    }

    private void setIcon(ImageIcon defaultIcon) {
        if (defaultIcon != null) {
            icon = defaultIcon;
            iconWidth = defaultIcon.getIconWidth();
            iconHeight = defaultIcon.getIconHeight();
        } else {
            logger.error("[DecorationImpl.setIcon] Can't set null icon");
        }
    }

    /**
     * Draw the icon.
     * @param g
     * @param box
     */
    public void draw(Graphics g, Rectangle box) {
        if (icon != null) {
            Point p = getCoordinates(box);
            logger.debug("[DecorationImpl.draw()] Drawing Decoration at ("
                         + p.x + "," + p.y + ")");
            icon.paintIcon(null, g, p.x, p.y);
        }
    }

    /**
     * Returns the coordinates where to draw the icon, given a Rectangle.
     * @param box
     * @return Point (x,y)
     */
    protected Point getCoordinates(Rectangle box) {
        int x = (orientation < 2) ? box.x + xOffset
                                  : box.x + box.width - xOffset - iconWidth;
        int y = (orientation % 2 == 0) ? box.y + yOffset
                                       : box.y + box.height - yOffset
                                       - iconHeight;
        return new Point(x, y);
    }

    public void write(StorableOutput dw) {
        dw.writeInt(xOffset);
        dw.writeInt(yOffset);
        dw.writeInt(orientation);
        if (icon != null) {
            dw.writeString(icon.getDescription());
        }
        logger.info("URI of storable stream: " + dw.getURI());
    }

    public void read(StorableInput dr) throws IOException {
        xOffset = dr.readInt();
        yOffset = dr.readInt();
        orientation = dr.readInt();
        String iconDesc = dr.readString();
        logger.debug("READ> icon filepath: " + iconDesc);
        setIcon(initDefaultIcon(iconDesc));
    }
}