package CH.ifa.draw.figures;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

import javax.swing.ImageIcon;


public class ClickableDecoration extends DecorationImpl {
    private Rectangle occupiedSpace = null;

    public ClickableDecoration() {
        super();
    }

    public ClickableDecoration(int x, int y, int orient) {
        super(x, y, orient);
    }

    public ClickableDecoration(int x, int y, int orient, ImageIcon icon) {
        super(x, y, orient, icon);
    }

    public ClickableDecoration(ImageIcon icon) {
        super(icon);
    }

    public void draw(Graphics g, Rectangle box) {
        Point topLeft = getCoordinates(box);
        occupiedSpace = new Rectangle(topLeft,
                                      new Dimension(iconWidth, iconHeight));
        logger.debug("[ClickableDecoration] I occupy the space "
                     + occupiedSpace);
        super.draw(g, box);
    }

    public boolean containsPoint(Point p) {
        boolean result = false;
        if (occupiedSpace != null) {
            result = occupiedSpace.contains(p);
        }
        return result;
    }

    /**
     * Called, when this ClickableDecoration is clicked.
     */
    public void clicked() {
        logger.debug("[ClickableDecoration] I was clicked, but don't know what to do.");
    }
}