package de.renew.appleui;

import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;

import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;


/**
 * This listener actually does the work which is promised by the
 * {@link AppleUI} plugin. It handles Apple-specific application
 * events.
 * <p>
 * </p>
 * Created: Thu Jul  8  2004
 *
 * @author Michael Duvigneau
 **/
class AppleUIListener extends ApplicationAdapter {
    private AboutDisplayer displayer = null;

    /**
     * Tells the plugin system to shut down when Command-Q has
     * been pressed (or a similar event occurs).
     **/
    public void handleQuit(final ApplicationEvent applicationEvent) {
        if (!applicationEvent.isHandled()) {
            PluginManager.getInstance().stop();
            // Tell MacOS that handling the request may take some
            // time...
            applicationEvent.setHandled(false);
        }
    }

    /**
     * Tries to open the file by issuing a <code>"gui"</code>
     * command to the plugin system. However, this command will
     * only be available if the "Renew Gui" plugin is loaded.
     **/
    public void handleOpenFile(final ApplicationEvent applicationEvent) {
        if (!applicationEvent.isHandled()) {
            CLCommand guiCommand = PluginManager.getInstance().getCLCommands()
                                                .get("gui");
            if (guiCommand != null) {
                guiCommand.execute(new String[] { applicationEvent.getFilename() },
                                   System.out);
                applicationEvent.setHandled(true);
            }
        }
    }

    /**
     * Tries to bring the main menu frame to front.
     * However, this command will
     * only be available if the "Renew Gui" plugin is loaded.
     **/
    public void handleReOpenApplication(final ApplicationEvent applicationEvent) {
        if (!applicationEvent.isHandled() && (displayer != null)) {
            displayer.bringMenuFrameToFront();
            applicationEvent.setHandled(true);
        }
    }

    /**
     * Configures an <code>AboutDisplayer</code>.
     *
     * @param displayer  the about box displayer.
     **/
    void setAboutDisplayer(AboutDisplayer displayer) {
        this.displayer = displayer;
    }

    /**
     * Opens the editor's about box if the "Renew Gui" plugin is
     * loaded.
     **/
    public final void handleAbout(final ApplicationEvent applicationEvent) {
        if (!applicationEvent.isHandled() && (displayer != null)) {
            displayer.displayAboutBox();
            applicationEvent.setHandled(true);
        }
    }
}