package de.renew.remote.cryptix;

import cryptix.provider.*;
import cryptix.provider.cipher.*;
import java.io.*;
import java.net.*;
import java.rmi.*;
import java.rmi.server.*;
import xjava.security.*;


public class DESSocket extends Socket
{
	private InputStream in;
	private OutputStream out;

	private byte[] key;

	public DESSocket(byte[] key)
	{
		super();
		this.key = key;
	}

	public DESSocket(String host, int port, byte[] key)
		throws IOException
	{
		super(host, port);
		this.key = key;
	}

	public synchronized void close()
		throws IOException
	{
		getOutputStream().flush();
		super.close();
	}

	public InputStream getInputStream()
		throws IOException
	{
		if (in == null)
		{
			try
			{
				in = new DESInputStream(super.getInputStream(), key);
			}
			catch (IOException e)
			{
				throw e;
			}
			catch (Exception e)
			{
				throw new IOException("Cannot create input stream: " + e);
			}
		}
		return in;
	}

	public OutputStream getOutputStream()
		throws IOException
	{
		if (out == null)
		{
			try
			{
				out = new DESOutputStream(super.getOutputStream(), key);
			}
			catch (IOException e)
			{
				throw e;
			}
			catch (Exception e)
			{
				throw new IOException("Cannot create output stream: " + e);
			}
		}
		return out;
	}
}
