/*
 * Decompiled with CFR 0.152.
 */
package de.renew.appleui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationListener;
import de.renew.appleui.AboutDisplayer;
import de.renew.appleui.AppleUIListener;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.SoftDependency;

public class AppleUI
extends PluginAdapter {
    private Application app = null;
    private AppleUIListener listener = null;
    private SoftDependency guiDependency;

    public AppleUI(PluginProperties pluginProperties) {
        super(pluginProperties);
        System.setProperty("com.apple.macos.useScreenMenubar", pluginProperties.getProperty("com.apple.macos.useScreenMenubar", "true"));
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", pluginProperties.getProperty("com.apple.mrj.application.apple.menu.about.name", "Renew"));
    }

    public void init() {
        this.app = new Application();
        this.listener = new AppleUIListener();
        this.setAboutDisplayer(null);
        this.app.addApplicationListener((ApplicationListener)this.listener);
        this.guiDependency = new SoftDependency((IPlugin)this, "de.renew.gui", "de.renew.appleui.GuiDependencyListener");
    }

    public boolean cleanup() {
        if (this.app != null) {
            this.app.removeApplicationListener((ApplicationListener)this.listener);
            this.app = null;
            this.listener = null;
        }
        if (this.guiDependency != null) {
            this.guiDependency.discard();
            this.guiDependency = null;
        }
        return true;
    }

    void setAboutDisplayer(AboutDisplayer aboutDisplayer) {
        if (this.app != null && this.listener != null) {
            this.app.setEnabledAboutMenu(aboutDisplayer != null);
            this.listener.setAboutDisplayer(aboutDisplayer);
        }
    }
}

