package de.renew.windowmanagement;

/**
 * Interface provides a shutdown hook and a boolean request if the application can be closed.
 */
public interface RenewShutdownHook {

    /**
     * Check if the conditions of this shutdown hook are fulfilled.
     *
     * @return true if the application can be safely shut down
     */
    boolean canClose();

    /**
     * Execute the shutdown hook.
     */
    void exit();
}
