package de.renew.windowmanagement;

import java.awt.Component;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;


/**
 * This is the implementation of DefaultKeyboardFocusManager that overrides the dispatchKeyEvent method.
 *
 * @version 1.0
 * @author "Timo Carl" <a href="6carl@informatik.uni-hamburg.de"></a>
 */
public class HotDrawFocusManager extends DefaultKeyboardFocusManager {
    private Component _component;

    /**
     * Sets the focus to a different component.
     *
     * @param component the component where you want to set the focus to.
     */
    public HotDrawFocusManager(Component component) {
        super();
        KeyboardFocusManager.setCurrentKeyboardFocusManager(this);
        this._component = component;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        boolean result = super.dispatchKeyEvent(e);
        if ((e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) > 0
            && !e.isConsumed()) {
            redispatchEvent(_component, e);
        }
        return result;
    }
}