<!-- Adapted from: https://www.writethedocs.org/guide/writing/beginners-guide-to-docs/ -->

# WindowManagement

## User Guide

_WindowManagement_ provides some core components for the Renew user interface.

### Features

- Adds dockable windows to the user interface.
- Provides a menubar for the UI.

### Example Usage

1. Open two new windows
2. Dock one window beside the other by Drag and Drop

### Provided Commands

<!-- Use the classes implementing CLCommand. The 'help' output of the command can be a useful description -->

- `darktheme` - change the color theme of the Nimbus look and feel to a dark blue variant

### Installation

Install _WindowManagement_ by putting the JAR file inside the `dist/plugins` directory.

It will be automatically loaded at startup of Renew.

### Dependencies

This plugin depends on the following plugins and external libraries:

<!-- must match the `module-info.java` -->

- `Loader`: (mandated)
- `log4j`: Logging framework
- `dockingframes`: Adds the basis for dockable windows

## Developer Guide

### Core Classes

- `WindowManagementPlugin`: Starts the plugin.
- `Workbench`: The Workbench class provides the main frame of the application.  
  It uses the "docking-frames" framework as an external window manager and provides adapter methods.  
  Dependant plugins can receive the `WorkbenchProxy` object via dependency injection.  
  Refer to the `GuiPlugin` or `NavigatorPlugin` classes on how this is done.  
  The proxy delegates to the main implementing Workbench class, if Renew is run with a gui, otherwise registered listeners are saved until a new mainframe is opened.
- `DarkThemeCLCommand`: Contains the console command to change the user interface theme.

### How to Extend

_WindowManagement_ exposes multiple Interfaces:
- `de.renew.windowmanagement.DraggableComponentDropTarget`
- `de.renew.windowmanagement.Part`
- `de.renew.windowmanagement.RenewShutdownHook`
- `de.renew.windowmanagement.View`
- `de.renew.windowmanagement.Workbench`

You can implement these interfaces to add additional functionality to the Gui.

### Additional Information

<!-- Common issues, explanations for inconsistencies, etc. -->

- You can register several listeners. Please refer to the docking-frames documentation on what they do.  
  Furthermore you can add view windows.  
  For these simply wrap the content (usually a JPanel) in a `DefaultSingleCDockable`.  
  It will then be shown at the specified location.  
  The locations are found as static variables in the `WorkbenchImpl` class.

- Before adding editor windows you first have to register a factory used to create these editors.  
For an example refer to the `StandardDrawingViewFactory` class in the CH plugin.

- When registering a menu, you can specify a section in which the entry should appear.  
The indices of the sections can be found as static variables in the `RenewMenuBar` class.  
If no index is specified, the entry will be put in the MISC section.

#### Draggable Components

The plugin furthermore provides some helper classes to implement draggable Components.  
This is for example used for the tool palettes in the CH plugin.  
(see also package `CH.ifa.draw.gui`)

You need a `DragCanvas` on which the shadows of the dragged Components are drawn,  
as well as a new `DraggableComponentAdapter` for each draggable Component.  
Draggable Components can be of any type extending the standard java class Component.

When the dragged component is dropped somewhere (but not on itself) the method `dropComponent(Component,Point)` is called in DragCanvas.  
This method is empty in the abstract super class and has to be implemented by extending classes.  
An example of how this can be used is found in the `CH.ifa.draw.gui` package.
<!-- Contribution Info -->

<!-- License -->