package de.renew.util;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNull;

/**
 * This is a TestCase for the BijectiveMap where the mapping is bijective. <br>
 *
 * You could use both values as keys and/or as values. <br>
 *
 * @author Benjamin Schleinzer 0schlein@informatik.uni-hamburg.de
 *
 * @version 1.0
 */
public class BijectiveMapTest {
    private BijectiveMap<String, Integer> _testMap;

    @BeforeEach
    public void setUp() {
        _testMap = new BijectiveMap<>();
        _testMap.put("one", 1);
        _testMap.put("two", 2);
        _testMap.put("three", 3);
    }

    @SuppressWarnings("RedundantOperationOnEmptyContainer")
    @Test
    public void testClear() {
        _testMap.clear();
        assertNull(_testMap.get("one"));
        assertNull(_testMap.getKey(1));
    }

    @Test
    public void testGetKey() {
        assertEquals("one", _testMap.getKey(1));
    }

    @Test
    public void testRemoveObject() {
        _testMap.remove("one");
        assertNull(_testMap.getKey(1));
        assertNull(_testMap.get("one"));
    }

    @Test
    public void testRemoveKey() {
        _testMap.removeKey(1);
        assertNull(_testMap.getKey(1));
        assertNull(_testMap.get("one"));
    }
}