package de.renew.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serial;
import java.io.Serializable;


/**
 * Wrapper to store a field and the object containing the field.
 * <p>
 * Created: Tue Feb  8  2000
 *
 * @author Michael Duvigneau
 */
class DelayedField implements Serializable {
    @Serial
    private static final long serialVersionUID = -6231461074991131516L;
    private final Object _field;
    private final DelayedFieldOwner _owner;

    DelayedField(Object field, DelayedFieldOwner owner) {
        this._field = field;
        this._owner = owner;
    }

    void reassign() throws IOException {
        _owner.reassignField(_field);
    }

    @Serial
    private void writeObject(ObjectOutputStream out) throws IOException {
        RenewObjectOutputStream rout = null;
        if (out instanceof RenewObjectOutputStream) {
            rout = (RenewObjectOutputStream) out;
        }
        if (rout != null) {
            rout.beginDomain(_owner);
        }
        out.defaultWriteObject();
        if (rout != null) {
            rout.endDomain(_owner);
        }
    }

    @Override
    public String toString() {
        return "DelayedField(_owner:" + _owner + ", value:" + _field + ")";
    }
}