package de.renew.splashscreen.proc;

import de.renew.plugin.load.ISplashscreenPlugin;

/**
 * An Interface for sequential processes.
 * A sequential process is a process, usually described by an AIP.
 * Use them to provide a defined structure from which the functionality is called.
 * Implementations of this interface are found automatically by the {@link de.renew.plugin.ServiceLookupInfrastructure} and are added to the available processes to be executed.
 *
 * @author Niklas Levens
 * @author Tom Dasenbrook
 */
public interface SequentialProcess {

    /**
     * Execute the process.
     *
     * @return A return value if the implementation requires a return value.
     */
    Object execute(Object[] args, ISplashscreenPlugin trigger);

    /**
     * Return the process specific key
     *
     * @return key as a String
     */
    String getKey();
}
