package de.renew.splashscreen.proc;

import java.beans.PropertyChangeEvent;

import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.splashscreen.implinterface.ImplInterface;

/**
 *  This class describes the property change process.
 *  This process is responsible for updating the displayed information and the progress bar.
 *
 * @author Niklas Levens
 * @author Tom Dasenbrook
 * @date Dec 7, 2025
 */
public class PropertyChange implements SequentialProcess {

    private final String PROCESS_KEY = "PROPERTY_CHANGE";

    @Override
    public Object execute(Object[] args, ISplashscreenPlugin trigger) {
        PropertyChangeEvent evt = (PropertyChangeEvent) args[0];
        ImplInterface _implInterface = new ImplInterface();
        _implInterface.progressBarPropertyChange(evt);
        return null;
    }

    @Override
    public String getKey() {
        return PROCESS_KEY;
    }
}
