package de.renew.splashscreen.proc;

import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.splashscreen.implinterface.ImplInterface;

/**
 * This class describes the cleanup process.
 * If a splashscreen exists, this process will close it.
 *
 * @author Niklas Levens
 * @author Tom Dasenbrook
 * @date Dec 7, 2025
 */
public class Cleanup implements SequentialProcess {

    private final String PROCESS_KEY = "CLEANUP";

    @Override
    public Object execute(Object[] args, ISplashscreenPlugin trigger) {
        SequentialProcess _closeSplashscreen = new CloseSplashscreen();;
        ImplInterface _implInterface = new ImplInterface();
        if (_implInterface.checkSplashScreenNotNull()) {
            _closeSplashscreen.execute(args, trigger);
        }
        _implInterface.setSplashscreenPlugin(null);
        return null;
    }

    @Override
    public String getKey() {
        return PROCESS_KEY;
    }
}
