package de.renew.splashscreen.implinterface;

import java.beans.PropertyChangeEvent;

import de.renew.plugin.load.ISplashscreenPlugin;
import de.renew.plugin.load.PluginLoaderComposition;
import de.renew.splashscreen.impl.RenewSplashScreen;

/**
 *  This class acts as an interface to the internal functions of the impl module.
 *  Use this to access the internal functions from a process.
 *
 * @author Niklas Levens
 * @author Tom Dasenbrook
 * @date Dec 02, 2025
 */
public class ImplInterface {

    private ISplashscreenPlugin _splashscreenPlugin;

    /**
     * Creates a new instance of the ImplInterface
     */
    public ImplInterface() {}

    /**
     * Get (singleton) instance of the {@link RenewSplashScreen}.
     *
     * @return the current instance of  {@link RenewSplashScreen}
     */
    public static RenewSplashScreen getRenewSplashscreenInstance() {
        return RenewSplashScreen.getInstance();
    }

    /**
     * Create and show the splashscreen.
     */
    public static void showSplashScreen() {
        getRenewSplashscreenInstance().showSplashScreen();
    }

    public void setSplashscreenPlugin(ISplashscreenPlugin splashscreenPlugin) {
        PluginLoaderComposition.setSplashScreen(splashscreenPlugin);
    }

    public boolean checkSplashScreenNotNull() {
        return getRenewSplashscreenInstance() != null;
    }

    public void closeSplashScreen() {
        getRenewSplashscreenInstance().closeSplashScreen();
    }

    public void progressBarPropertyChange(PropertyChangeEvent evt) {
        getRenewSplashscreenInstance().progressBarPropertyChange(evt);
    }

}
