package de.renew.splashscreen.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.JPanel;


/**
 * This class is an extension of {@link JPanel}.<br>
 * It draws an image as background image and resizes the {@link JPanel} to the
 * specified {@link Dimension}.
 *
 * @author Eva Mueller
 * @date Nov 27, 2010
 * @version 0.1
 */
public class ImagePanel extends JPanel {
    private static final int TOP_LEFT_POSITION = 10;
    /**
     * The image to be used as the background of this panel.
     */
    private final Image _img;

    /**
     * Create an {@code ImagePanel} with given <b>size</b> and<br>
     * use given <b>image</b> as background image.
     *
     * @param image [{@link Image}] The background image
     * @param size [{@link Dimension}] The size of the image panel
     * @date Nov 27, 2010
     */
    public ImagePanel(Image image, Dimension size) {
        this._img = image;
        setSize(size);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (_img != null) {
            g.drawImage(_img, TOP_LEFT_POSITION, TOP_LEFT_POSITION, null);
        } else {
            super.paintComponent(g);
        }
    }
}