package de.renew.simulatorontology.shadow;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * Test class for {@link ShadowNode}.
 * Tests only the relevant (non-trivial) methods.
 */
class ShadowNodeTest {
    /**
     * Mock instance of ShadowNet.
     */
    private ShadowNet _shadowNetMock;
    /**
     * Instance of ShadowNode to be tested.
     */
    private ShadowNode _shadowNode;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    public void setUp() {
        // Create a mock ShadowNet
        _shadowNetMock = mock(ShadowNet.class);
        when(_shadowNetMock.getName()).thenReturn("testNet");

        // Create a ShadowNode instance
        _shadowNode = new ShadowNode(_shadowNetMock) {
            @Override
            public void setName(String name) {
                super.setName(name);
            }
        };
    }

    /**
     * Test method for the constructor of {@link ShadowNode}.
     */
    @Test
    public void testShadowNode() {
        assertThat(_shadowNode).isNotNull();
        assertThat(_shadowNetMock).isEqualTo(_shadowNode.getNet());
    }

    /**
     * Test method for toString.
     * Test if the shadow node has no name but an ID.
     */
    @Test
    public void testToStringID() {
        // Given
        _shadowNode.setID(0);
        // The class name is ShadowNodeTest$1 because of the anonymous class
        String expectedStringNoName = "ShadowNodeTest$1 (0)";

        // When & Then
        assertThat(_shadowNode.toString()).isEqualTo(expectedStringNoName);
    }

    /**
     * Test method for toString.
     * Test if the shadow node has a name.
     */
    @Test
    public void testToStringName() {
        // Given
        _shadowNode.setName("testNode");
        // The class name is ShadowNodeTest$1 because of the anonymous class
        String expectedStringName = "ShadowNodeTest$1 \"testNode\"";

        // When & Then
        assertThat(_shadowNode.toString()).isEqualTo(expectedStringName);
    }
}