package de.renew.simulatorontology.shadow;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;

/**
 * Test class for {@link ShadowNet}.
 * Tests only the relevant (non-trivial) methods.
 */
class ShadowNetTest {
    private static final String NAME_MOCK = "testNet";
    private ShadowNet _shadowNet;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    public void setUp() {
        // Create a mock ShadowNetSystem
        ShadowNetSystem shadowNetSystemMock = mock(ShadowNetSystem.class);

        // Create a new ShadowNet instance
        _shadowNet = new ShadowNet(NAME_MOCK, shadowNetSystemMock);
    }

    /**
     * Test method for the constructor of {@link ShadowNet}.
     */
    @Test
    public void testShadowNet() {
        // Then
        assertThat(_shadowNet).isNotNull();
        assertThat(NAME_MOCK).isEqualTo(_shadowNet.getName());
    }

    @Test
    public void testAdd() {
        // Given
        ShadowNetElement shadowNetElementMock = mock(ShadowNetElement.class);

        // When
        _shadowNet.add(shadowNetElementMock);

        // Then
        assertThat(_shadowNet.elements()).contains(shadowNetElementMock);
    }

    @Test
    public void testRemove() {
        // Given
        ShadowNetElement shadowNetElementMock = mock(ShadowNetElement.class);
        _shadowNet.add(shadowNetElementMock);

        // When
        _shadowNet.remove(shadowNetElementMock);

        // Then
        assertThat(_shadowNet.elements()).doesNotContain(shadowNetElementMock);
    }
}