package de.renew.simulatorontology.shadow;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;

/**
 * Test class for {@link ShadowDeclarationNode}.
 * Tests only the relevant (non-trivial) methods.
 */
class ShadowNetSystemTest {
    private ShadowNetSystem _shadowNetSystem;
    private ShadowNetLoader _shadowNetLoaderMock;
    private ShadowNet _shadowNetMock;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    public void setUp() {
        _shadowNetLoaderMock = mock(ShadowNetLoader.class);
        _shadowNetMock = mock(ShadowNet.class);

        _shadowNetSystem = new ShadowNetSystem(_shadowNetLoaderMock);
    }

    /**
     * Test method for the constructor of {@link ShadowNetSystem}.
     */
    @Test
    public void testShadowNetSystem() {
        // Then
        assertThat(_shadowNetSystem).isNotNull();
        assertThat(_shadowNetSystem.getNetLoader()).isEqualTo(_shadowNetLoaderMock);
    }


    /**
     * Test method for {@link ShadowNetSystem#add(ShadowNet)}.
     */
    @Test
    public void testAdd() {
        // When
        _shadowNetSystem.add(_shadowNetMock);

        // Then
        assertThat(_shadowNetSystem.elements()).contains(_shadowNetMock);
    }

    /**
     * Test method for {@link ShadowNetSystem#remove(ShadowNet)}.
     */
    @Test
    public void testRemove() {
        // Given
        _shadowNetSystem.add(_shadowNetMock);

        // When
        _shadowNetSystem.remove(_shadowNetMock);

        // Then
        assertThat(_shadowNetSystem.elements()).doesNotContain(_shadowNetMock);
    }
}