package de.renew.simulatorontology.shadow;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.any;
import static org.mockito.Mockito.doNothing;
import static org.mockito.Mockito.mock;

/**
 * Test class for {@link ShadowDeclarationNode}.
 * Tests only the relevant (non-trivial) methods.
 */
class ShadowDeclarationNodeTest {
    private static final String NAME_MOCK = "testDeclaration";

    private ShadowDeclarationNode _shadowDeclarationNode;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    public void setUp() {
        ShadowNet shadowNetMock = mock(ShadowNet.class);
        doNothing().when(shadowNetMock).add(any());

        _shadowDeclarationNode = new ShadowDeclarationNode(shadowNetMock, NAME_MOCK);
    }

    /**
     * Test method for the constructor of {@link ShadowDeclarationNode}.
     */
    @Test
    public void testShadowDeclarationNode() {
        // Then
        assertThat(_shadowDeclarationNode).isNotNull();
        assertThat(_shadowDeclarationNode.getInscription()).isEqualTo(NAME_MOCK);
    }
}