/*
 * Created on 19.10.2004
 */

package de.renew.simulatorontology.simulation;


/**
 * Represents a unique identifier for a simulation step within a specific simulation run.
 *
 * @author Sven Offermann
 */
public class StepIdentifier implements Comparable<StepIdentifier> {
    private final long _simulationRunId;
    private final long[] _stepCounts;

    public StepIdentifier(long simulationRunId, long[] stepCounts) {
        _simulationRunId = simulationRunId;
        _stepCounts = stepCounts;
    }

    public long[] getComponents() {
        return _stepCounts;
    }

    public long getSimulationRunId() {
        return _simulationRunId;
    }

    @Override
    public int hashCode() {
        if (_stepCounts.length != 0) {
            return (int) _stepCounts[0];
        }

        return 0;
    }

    @Override
    public boolean equals(Object otherObj) {
        if (otherObj instanceof StepIdentifier other) {
            return (compareTo(other) == 0);
        }

        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");

        if (_stepCounts.length != 0) {
            builder.append(_stepCounts[0]);
        }

        for (int x = 1; x < _stepCounts.length; x++) {
            builder.append(",");
            builder.append(_stepCounts[x]);
        }

        builder.append(")");

        return builder.toString();
    }

    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    @Override
    public int compareTo(final StepIdentifier other) throws ClassCastException {
        long[] otherComp = other.getComponents();

        // first compare the simulationRunId
        if (_simulationRunId < other._simulationRunId) {
            // other simulationRunId is greater
            return -1;
        } else if (_simulationRunId > other._simulationRunId) {
            // other simulationRunId is lesser
            return 1;
        }

        // second compare the elements of the stepCountVector
        // if the simulationId is equal, the stepIdentifiers should
        // come from the same simulator, so the length of the 
        // stepCountVector should be the same.
        for (int x = 0; x < otherComp.length; x++) {
            if (_stepCounts[x] < otherComp[x]) {
                // other StepIdentifier is greater
                return -1;
            } else if (_stepCounts[x] > otherComp[x]) {
                // other StepIdentifier is lesser
                return 1;
            }
        }

        // all vector elements and the simulationRunId are equal,
        // so the StepIdentifiers are equal.
        return 0;
    }
}