package de.renew.simulatorontology.shadow;

import java.util.Collection;

/**
 * A {@code ShadowCompilationResult} contains information about the compilation of a shadow net or shadow net system.
 */
public interface ShadowCompilationResult {

    /**
     * Returns whether any nets that were previously not compiled were compiled.
     *
     * @return {@code true}, if any nets that were previously not compiled were compiled, {@code false} otherwise
     */
    boolean containsNewlyCompiledNets();

    /**
     * Returns the names of all shadow nets that were newly compiled, i.e. previously not yet compiled.
     *
     * @return a collection containing the names of all shadow nets that were newly compiled, i.e. previously not yet compiled.
     */
    Collection<String> allNewlyCompiledNetNames();
}
