package de.renew.shadowcompiler;

import java.util.Collections;
import java.util.List;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.net.Place;
import de.renew.net.Transition;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.ShadowTransition;

import static org.assertj.core.api.Assertions.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * Test class for {@link ContextLookup}.
 * Tests only the relevant (non-trivial) methods.
 */
class ContextLookupTest {
    private static final String SHADOW_PLACE_CONTEXT = "testShadowPlace";
    private static final String SHADOW_TRANSITION_CONTEXT = "testShadowTransition";

    private Place _placeMock;
    private Transition _transitionMock;
    private ContextLookup _contextLookup;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    public void setUp() {
        //Given (part of Given for every possible test method)
        ShadowLookup shadowLookupMock = mock(ShadowLookup.class);
        ShadowPlace shadowPlaceMock = mock(ShadowPlace.class);
        when(shadowPlaceMock.getContext()).thenReturn(SHADOW_PLACE_CONTEXT);
        _placeMock = mock(Place.class);
        ShadowTransition shadowTransitionMock = mock(ShadowTransition.class);
        when(shadowTransitionMock.getContext()).thenReturn(SHADOW_TRANSITION_CONTEXT);
        _transitionMock = mock(Transition.class);

        when(shadowLookupMock.allPlaces())
            .thenReturn(Collections.enumeration(List.of(shadowPlaceMock)));
        when(shadowLookupMock.get(shadowPlaceMock)).thenReturn(_placeMock);

        when(shadowLookupMock.allTransitions())
            .thenReturn(Collections.enumeration(List.of(shadowTransitionMock)));
        when(shadowLookupMock.get(shadowTransitionMock)).thenReturn(_transitionMock);

        // When (part of When for every possible test method)
        _contextLookup = new ContextLookup(shadowLookupMock);
    }

    /**
     * Test method for {@link ContextLookup#ContextLookup(ShadowLookup)}.
     */
    @Test
    public void testContextLookup() {
        // Then
        assertThat(_contextLookup).isNotNull();
        assertThat(_contextLookup.getPlace(SHADOW_PLACE_CONTEXT)).isEqualTo(_placeMock);
        assertThat(_contextLookup.getTransition(SHADOW_TRANSITION_CONTEXT))
            .isEqualTo(_transitionMock);
    }

}