package de.renew.net.inscription.transition;

import java.util.Collection;
import java.util.LinkedList;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Test class for {@link SimpleEnumeratorInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
class SimpleEnumeratorInscriptionTest extends InscriptionTest {
    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        super.setUp();
    }

    /**
     * Test method for {@link SimpleEnumeratorInscription#makeOccurrences(VariableMapper, NetInstance, Searcher)}.
     *
     * @param isBound true if bound should be checked.
     * @throws Impossible if it is impossible to make the {@code Occurrence}s.
     */
    @ParameterizedTest
    @ValueSource(booleans = { true, false })
    void testMakeOccurrences(boolean isBound) throws Impossible {
        //given
        Collection<Object> collection = new LinkedList<>();
        SimpleEnumeratorInscription inscription =
            new SimpleEnumeratorInscription(_mockExpression, collection, isBound, _transition);

        //when
        Collection<Occurrence> occurrences =
            inscription.makeOccurrences(_mapper, _mockNetInstance, _searcher);

        //then
        SimpleEnumeratorOccurrence expectedOccurrence = new SimpleEnumeratorOccurrence(
            _mockExpression, isBound, _mapper, collection,
            _mockNetInstance.getInstance(_transition));
        assertThat(occurrences).isNotNull().hasSize(1);
        assertThat(occurrences).first().isInstanceOf(SimpleEnumeratorOccurrence.class)
            .usingRecursiveComparison().isEqualTo(expectedOccurrence);
    }
}