package de.renew.net.inscription.transition;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.junit.jupiter.MockitoExtension;

import de.renew.engine.searcher.Searcher;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.Net;
import de.renew.net.NetElementID;
import de.renew.net.NetInstance;
import de.renew.net.Transition;
import de.renew.unify.Impossible;

import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.when;

/**
 * Abstract test class for the Inscription test classes.
 */
@ExtendWith(MockitoExtension.class)
abstract class InscriptionTest {
    private static final String TRANSITION_NAME = "Transition";

    protected MockedStatic<SimulationThreadPool> _mockedPool;

    @Mock
    protected Expression _mockExpression;

    @Mock
    protected NetInstance _mockNetInstance;

    protected Transition _transition;

    protected VariableMapper _mapper;

    protected Searcher _searcher;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        _mockedPool = mockStatic(SimulationThreadPool.class);
        when(SimulationThreadPool.isSimulationThread()).thenReturn(true);

        _transition = new Transition(new Net(), TRANSITION_NAME, new NetElementID());
        _mapper = new VariableMapper();
        _searcher = new Searcher();
    }

    /**
     * Setup method to close this test environment.
     */
    @AfterEach
    void tearDown() {
        _mockedPool.close();
    }
}
