package de.renew.net.inscription.transition;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.net.NetInstance;
import de.renew.simulatorontology.simulation.StepIdentifier;
import de.renew.unify.Impossible;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.mockStatic;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * Test class for {@link EarlyConfirmer}.
 * Tests only the relevant (non-trivial) methods.
 */
class EarlyConfirmerTest {
    private MockedStatic<SimulationThreadPool> _mockedPool;

    @Mock
    private StepIdentifier _mockStepIdentifier;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        _mockedPool = mockStatic(SimulationThreadPool.class);
        when(SimulationThreadPool.isSimulationThread()).thenReturn(true);
    }

    /**
     * Setup method to close this test environment.
     */
    @AfterEach
    void tearDown() {
        _mockedPool.close();
    }

    /**
     * Test method for {@link EarlyConfirmer#verify(StepIdentifier)}.
     */
    @Test
    public void testVerify() {
        //given
        NetInstance mockNetInstance = mock(NetInstance.class);
        EarlyConfirmer earlyConfirmer = new EarlyConfirmer(mockNetInstance);

        //when
        earlyConfirmer.verify(_mockStepIdentifier);

        //then
        verify(mockNetInstance).earlyConfirmation();
    }

    /**
     * Test method for {@link EarlyConfirmer#execute(StepIdentifier)}.
     */
    @Test
    public void testExecute() {
        //given
        NetInstance mockNetInstance = mock(NetInstance.class);
        EarlyConfirmer earlyConfirmer = new EarlyConfirmer(mockNetInstance);

        //when
        earlyConfirmer.execute(_mockStepIdentifier);

        //then
        verify(mockNetInstance).earlyConfirmationTrace(_mockStepIdentifier);
    }
}