package de.renew.net.inscription.transition;

import java.util.Collection;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.LocalVariable;
import de.renew.expression.VariableMapper;
import de.renew.net.Net;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Test class for {@link CreationInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
class CreationInscriptionTest extends InscriptionTest {
    @Mock
    private Net _mockNet;
    @Mock
    private LocalVariable _mockLocalVariable;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        super.setUp();
    }

    /**
     * Test method for {@link CreationInscription#makeOccurrences(VariableMapper, NetInstance, Searcher)}
     */
    @Test
    public void testMakeOccurrences() {
        //given
        CreationInscription creationInscription =
            new CreationInscription(_mockNet, _mockLocalVariable, _transition);

        //when
        Collection<Occurrence> occurrences =
            creationInscription.makeOccurrences(_mapper, _mockNetInstance, _searcher);

        //then
        CreationOccurrence expectedOccurrence = new CreationOccurrence(
            _mapper.map(_mockLocalVariable), _mockNet, _mockNetInstance.getInstance(_transition));
        assertThat(occurrences).isNotNull().hasSize(1);
        assertThat(occurrences).first().isInstanceOf(CreationOccurrence.class)
            .usingRecursiveComparison().isEqualTo(expectedOccurrence);
    }
}