package de.renew.net.inscription.transition;

import java.util.Collection;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.inscription.TransitionInscription;
import de.renew.unify.Impossible;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Test class for {@link ConditionalInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
class ConditionalInscriptionTest extends InscriptionTest {
    @Mock
    private TransitionInscription _mockTransitionInscription;

    private ConditionalInscription _conditionalInscription;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        super.setUp();
        _conditionalInscription =
            new ConditionalInscription(_mockExpression, _mockTransitionInscription, _transition);
    }

    /**
     * Test method for {@link ConditionalInscription#makeOccurrences(VariableMapper, NetInstance, Searcher)}.
     */
    @Test
    public void testMakeOccurrences() {
        //when
        Collection<Occurrence> occurrences =
            _conditionalInscription.makeOccurrences(_mapper, _mockNetInstance, _searcher);

        //then
        ConditionalOccurrence expectedOccurrence = new ConditionalOccurrence(
            _conditionalInscription, _mapper, _mockNetInstance, _transition);
        assertThat(occurrences).isNotNull().hasSize(1);
        assertThat(occurrences).first().isInstanceOf(ConditionalOccurrence.class)
            .usingRecursiveComparison().isEqualTo(expectedOccurrence);
    }
}