package de.renew.net.inscription.transition;

import java.util.Collection;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.unify.Impossible;

import static org.assertj.core.api.Assertions.assertThat;

/**
 * Test class for {@link ActionInscription}.
 * Tests only the relevant (non-trivial) methods.
 */
class ActionInscriptionTest extends InscriptionTest {
    private ActionInscription _actionInscription;

    /**
     * Setup method to initialize this test environment.
     */
    @BeforeEach
    void setUp() throws Impossible {
        super.setUp();

        _actionInscription = new ActionInscription(_mockExpression, _transition);
    }


    /**
     * Test method for {@link ActionInscription#makeOccurrences(VariableMapper, NetInstance, Searcher)}.
     */
    @Test
    public void testMakeOccurrences() {
        //when
        Collection<Occurrence> occurrences =
            _actionInscription.makeOccurrences(_mapper, _mockNetInstance, _searcher);
        //then
        ActionOccurrence expectedOccurrence = new ActionOccurrence(
            _mockExpression, _mapper, _mockNetInstance.getInstance(_transition));

        assertThat(occurrences).isNotNull().hasSize(1);
        assertThat(occurrences).first().isInstanceOf(ActionOccurrence.class)
            .usingRecursiveComparison().isEqualTo(expectedOccurrence);
    }
}