package de.renew.engine.searchqueue;

import de.renew.engine.searcher.Searchable;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.searcher.TriggerCollection;
import de.renew.engine.searcher.TriggerableCollection;

/**
 * Helper class to implement a {@code Searchable} to include in the
 * different {@code SearchQueues} while testing.
 */
class EmptySearchable implements Searchable {
    @Override
    public TriggerCollection triggers() {
        return new EmptyTriggerCollection();
    }

    @Override
    public void proposeSearch() {}

    @Override
    public void startSearch(Searcher searcher) {}

    private static class EmptyTriggerCollection implements TriggerCollection {
        @Override
        public void include(TriggerableCollection trigger) {}

        @Override
        public void exclude(TriggerableCollection trigger) {}

        @Override
        public void clear() {}
    }
}
