package de.renew.unify;


/**
 * This is the common interface to all the classes calculator,
 * tuple, list, unknown, and variable. If further subclasses
 * are added, the classes Unify and Copier must be updated.
 **/
interface Unifiable {
    /**
     * Returns whether this object is complete, i.e. its value cannot further
     * be changed by unification.
     *
     * @return {@code true} if no parts of this object are unknown, otherwise {@code false}
     */
    boolean isComplete();

    /**
     * Returns whether this object is bound, i.e. it is fully calculated.
     *
     * @return {@code true} if this object is bound to a real value, otherwise {@code false}
     */
    boolean isBound();
}