package de.renew.unify;

import java.util.Iterator;

/**
 * A custom Iterator for {@link Tuple}
 */
public class TupleIterator implements Iterator<Object> {
    private final Tuple _tuple;
    private int _index = 0;

    /**
     * Constructor for the TupleIterator. Sets the tuple to the given tuple.
     *
     * @param tuple the {@link Tuple} to be iterated
     */
    public TupleIterator(Tuple tuple) {
        _tuple = tuple;
    }

    @Override
    public boolean hasNext() {
        return _index < _tuple.getArity();
    }

    @Override
    public Object next() {
        return _tuple.getComponent(_index++);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}