package de.renew.unify;

/**
 * This class can restore changes to a previous state.
 * <p>
 * Implementations of this interface encapsulate the logic needed to
 * restore an object to a previous state. It is used in conjunction
 * with an {@link IStateRecorder} to support backtracking.
 */
public interface StateRestorer {

    /**
     * Reverts the change encapsulated by this restorer.
     */
    void restore();
}