package de.renew.unify;

import java.util.Set;


/**
 * Generic interface to allow any class implementing {@link Unifiable} to
 * specify its own implementation of unifySilently, without having to modify
 * Unify or Copier.
 *
 * @author Friedrich Delgado Friedrichs
 */
public interface SilentlyUnifiable extends Unifiable {
    /**
     * Unify this object with another object without notifying.
     * <p>
     * This is the internal unification method that records
     * all required notifications in a given updatable set.
     * It is assumed that all listeners will be notified later
     * on.
     *
     * @param right the object to unify with
     * @param recorder the state recorder to use
     * @param listeners the set of listeners to notify
     * @throws Impossible if the unification is impossible
     */
    void unifySilently(Object right, IStateRecorder recorder, Set<Notifiable> listeners)
        throws Impossible;

    /**
     * If the object is complete, make a permanent copy.
     * If the object is not complete, make a copy and
     * insert new unknown objects appropriately.
     *<p>
     * This method should not be called from within during
     * a notification callback.
     * <p>
     * This method should not be called while there might be
     * a need to undo any operation on the created
     * copies.
     *
     * @param copier the copier to use
     * @return a fresh copy of the object
     */
    SilentlyUnifiable copy(Copier copier);
}