package de.renew.unify;

import java.util.Set;

/**
 * Referers are objects that hold a {@link Reference} to other objects and want
 * to be notified about their completeness.
 */
public interface Referer {
    /**
     * Notifies the {@code Referer} that its referenced value is possibly completed.
     *
     * @param listeners set of {@link Notifiable}s so that the Referer can
     *                  add its own listener
     * @param recorder the {@link IStateRecorder}
     * @throws Impossible if an impossible state is encountered
     */
    void possiblyCompleted(Set<Notifiable> listeners, IStateRecorder recorder) throws Impossible;
}