package de.renew.shadowcompiler;

import de.renew.simulatorontology.shadow.ShadowNetLoader;
import de.renew.simulatorontology.shadow.ShadowNetSystem;

/**
 * This class is responsible for creating {@link ShadowNetSystem} instances.
 */
public final class ShadowNetSystemCreator {

    /**
     * Static class, so no instances needed.
     */
    private ShadowNetSystemCreator() {}

    /**
     * Creates a new {@code ShadowNetSystem}. During compilation (see {@link ShadowNetSystemCompiler#compile(ShadowNetSystem)})
     * the used compiler will be generated using the given factory.
     *
     * @param factory the factory to generate the {@code ShadowCompiler} that will be used for compilation
     * @return a new {@code ShadowNetSystem}
     */
    public static ShadowNetSystem createWithCompiler(ShadowCompilerFactory factory) {
        return createWithCompiler(null, factory);
    }

    /**
     * Creates a new {@code ShadowNetSystem} that will be initialised with the given {@code ShadowNetLoader}. During compilation (see {@link ShadowNetSystemCompiler#compile(ShadowNetSystem)})
     * the used compiler will be generated using the given factory.
     *
     * @param netLoader the net loader that the {@code ShadowNetSystem} will use
     * @param factory the factory to generate the {@code ShadowCompiler} that will be used for compilation
     * @return a new {@code ShadowNetSystem}
     */
    public static ShadowNetSystem createWithCompiler(
        ShadowNetLoader netLoader, ShadowCompilerFactory factory)
    {
        ShadowNetSystem shadowNetSystem = new ShadowNetSystem(netLoader);
        ShadowNetSystemCompiler.getInstance().setDefaultCompilerFactory(factory, shadowNetSystem);
        return shadowNetSystem;
    }
}
