package de.renew.shadowcompiler;


/**
 * A factory that creates shadow lookup extension
 * of a certain category.
 **/
public interface ShadowLookupExtensionFactory {

    /**
     * Return the extension category handled by this
     * factory.
     *
     * @return the category handled by this factory
     **/
    String getCategory();

    /**
     * Return a new instance of the extension class
     * managed by this factory.
     *
     * @return a new instance of the extension class managed by this factory
     **/
    ShadowLookupExtension createExtension();
}