package de.renew.shadowcompiler;


import de.renew.simulatorontology.shadow.SyntaxException;

/**
 * An {@code InscriptionValidator} may be used to validate the different inscription types (arc, declaration, place and transition)
 * of a {@code ShadowNet}.
 */
public interface InscriptionValidator {

    /**
     * Checks the text of an arc inscription for syntax errors.
     *
     * @param inscription the text that must be checked
     * @param special a boolean flag that the compiler may use to implement different node types
     * @return a message containing the result of the syntax check
     * @throws SyntaxException if there is a syntax error in the arc inscription
     */
    String checkArcInscription(String inscription, boolean special) throws SyntaxException;

    /**
     * Checks the text of a declaration node for syntax errors.
     *
     * @param inscription the text that must be checked
     * @param special a boolean flag that the compiler may use to implement different node types
     * @return a message containing the result of the syntax check
     * @throws SyntaxException if there is a syntax error in the text
     */
    String checkDeclarationNode(String inscription, boolean special) throws SyntaxException;

    /**
     * Checks the text of a place inscription for syntax errors.
     *
     * @param inscription the text that must be checked
     * @param special a boolean flag that the compiler may use to implement different node types
     * @return a message containing the result of the syntax check
     * @throws SyntaxException if there is a syntax error in the place inscription
     */
    String checkPlaceInscription(String inscription, boolean special) throws SyntaxException;

    /**
     * Checks the text of a transition inscription for syntax errors.
     *
     * @param inscription the text that must be checked
     * @param special a boolean flag that the compiler may use to implement different node types
     * @return a message containing the result of the syntax check
     * @throws SyntaxException if there is a syntax error in the inscription
     */
    String checkTransitionInscription(String inscription, boolean special) throws SyntaxException;
}
