package de.renew.net.inscription.transition;

import java.util.Collection;
import java.util.Collections;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.engine.thread.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.inscription.TransitionInscription;


/**
 * I represent an uplink that can be inscribed to a transition.
 * I do not do anything, except remembering my name
 * and my argument expression.
 *
 * @author Olaf Kummer
 **/
public class UplinkInscription implements TransitionInscription {

    /**
     * My name.
     **/
    private String _name;

    /**
     * My argument expression. Typically, this is a tuple expression.
     **/
    private final Expression _params;

    /**
     * I (an uplink inscription) am created. I will store
     * the given name and expression
     * for later retrieval.
     *
     * @param name the name of the channel that I represent
     * @param params the expression that must match the expression
     * of the respective uplink
     **/
    public UplinkInscription(String name, Expression params) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _name = name;
        _params = params;
    }

    // Refactoring
    /**
     * The start index of the uplink line.
     */
    private int _uplinkBeginLine;
    /**
     * The start index of the uplink column.
     */
    private int _uplinkBeginColumn;
    /**
     * The end index of the uplink line.
     */
    private int _uplinkEndLine;
    /**
     * The end index of the uplink column.
     */
    private int _uplinkEndColumn;
    /**
     * The start index of the name line.
     */
    private int _nameBeginLine;
    /**
     * The start index of the name column.
     */
    private int _nameBeginColumn;
    /**
     * The end index of the name line.
     */
    private int _nameEndLine;
    /**
     * The end index of the name column.
     */
    private int _nameEndColumn;

    @Override
    public Collection<Occurrence> makeOccurrences(
        VariableMapper mapper, NetInstance netInstance, Searcher searcher)
    {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return Collections.emptySet();
    }

    /**
     * Getter the {@code name}.
     *
     * @return {@code name}
     */
    public String getName() {
        return _name;
    }

    /**
     * Setter for {@code name}.
     *
     * @param name the name to set
     */
    public void setName(String name) {
        _name = name;
    }

    /**
     * Getter the {@code params}.
     *
     * @return {@code params}
     */
    public Expression getParams() {
        return _params;
    }

    /**
     * Getter the {@code uplinkBeginLine}.
     *
     * @return {@code uplinkBeginLine}
     */
    public int getUplinkBeginLine() {
        return _uplinkBeginLine;
    }

    /**
     * Getter the {@code uplinkBeginLine}.
     *
     * @return {@code uplinkBeginLine}
     */
    public int getUplinkBeginColumn() {
        return _uplinkBeginColumn;
    }

    /**
     * Getter the {@code uplinkEndLine}.
     *
     * @return {@code uplinkEndLine}
     */
    public int getUplinkEndLine() {
        return _uplinkEndLine;
    }

    /**
     * Getter the {@code uplinkEndColumn}.
     *
     * @return {@code uplinkEndColumn}
     */
    public int getUplinkEndColumn() {
        return _uplinkEndColumn;
    }

    /**
     * Getter the {@code nameBeginLine}.
     *
     * @return {@code nameBeginLine}
     */
    public int getNameBeginLine() {
        return _nameBeginLine;
    }

    /**
     * Getter the {@code nameBeginColumn}.
     *
     * @return {@code nameBeginColumn}
     */
    public int getNameBeginColumn() {
        return _nameBeginColumn;
    }

    /**
     * Getter the {@code nameEndLine}.
     *
     * @return {@code nameEndLine}
     */
    public int getNameEndLine() {
        return _nameEndLine;
    }

    /**
     * Getter the {@code nameEndColumn}.
     *
     * @return {@code nameEndColumn}
     */
    public int getNameEndColumn() {
        return _nameEndColumn;
    }

    /**
     * Setter for {@code uplinkBeginLine}.
     *
     * @param uplinkBeginLine the uplinkBeginLine to set
     */
    public void setUplinkBeginLine(int uplinkBeginLine) {
        _uplinkBeginLine = uplinkBeginLine;
    }

    /**
     * Setter for {@code uplinkBeginColumn}.
     *
     * @param uplinkBeginColumn the uplinkBeginColumn to set
     */
    public void setUplinkBeginColumn(int uplinkBeginColumn) {
        _uplinkBeginColumn = uplinkBeginColumn;
    }

    /**
     * Setter for {@code uplinkEndLine}.
     *
     * @param uplinkEndLine the uplinkEndLine to set
     */
    public void setUplinkEndLine(int uplinkEndLine) {
        _uplinkEndLine = uplinkEndLine;
    }

    /**
     * Setter for {@code uplinkEndColumn}.
     *
     * @param uplinkEndColumn the uplinkEndColumn to set
     */
    public void setUplinkEndColumn(int uplinkEndColumn) {
        _uplinkEndColumn = uplinkEndColumn;
    }

    /**
     * Setter for {@code nameBeginLine}.
     *
     * @param nameBeginLine the nameBeginLine to set
     */
    public void setNameBeginLine(int nameBeginLine) {
        _nameBeginLine = nameBeginLine;
    }

    /**
     * Setter for {@code nameBeginColumn}.
     *
     * @param nameBeginColumn the nameBeginColumn to set
     */
    public void setNameBeginColumn(int nameBeginColumn) {
        _nameBeginColumn = nameBeginColumn;
    }

    /**
     * Setter for {@code nameEndLine}.
     *
     * @param nameEndLine the nameEndLine to set
     */
    public void setNameEndLine(int nameEndLine) {
        _nameEndLine = nameEndLine;
    }

    /**
     * Setter for {@code nameEndColumn}.
     *
     * @param nameEndColumn the nameEndColumn to set
     */
    public void setNameEndColumn(int nameEndColumn) {
        _nameEndColumn = nameEndColumn;
    }
}
