package de.renew.net.inscription.transition;

import java.util.Collection;
import java.util.Collections;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.TransitionInstance;

import static de.renew.unify.Unify.isBound;


class SimpleEnumeratorOccurrence extends EnumeratorOccurrence {
    private final Collection<Object> _collection;

    public SimpleEnumeratorOccurrence(
        Expression expression, boolean checkBound, VariableMapper mapper,
        Collection<Object> collection, TransitionInstance tInstance)
    {
        super(expression, checkBound, mapper, tInstance);
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _collection = collection;
    }

    @Override
    public Collection<Object> getCandidates(Object pattern) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        if (isBound(pattern)) {
            if (_collection.contains(pattern)) {
                return Collections.singleton(pattern);
            }
            return Collections.emptySet();
        }
        return _collection;
    }
}