package de.renew.net.inscription.transition;

import java.util.Collection;

import de.renew.engine.thread.SimulationThreadPool;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.TransitionInstance;
import de.renew.util.IntegerRangeSet;


class RangeEnumeratorOccurrence extends EnumeratorOccurrence {
    private final int _first;
    private final int _last;

    public RangeEnumeratorOccurrence(
        Expression expression, boolean checkBound, VariableMapper mapper, int first, int last,
        TransitionInstance tInstance)
    {
        super(expression, checkBound, mapper, tInstance);
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        _first = first;
        _last = last;
    }

    @Override
    public Collection<?> getCandidates(Object pattern) {
        assert SimulationThreadPool.isSimulationThread() : "is not in a simulation thread";
        return new IntegerRangeSet(_first, _last);
    }
}