package de.renew.net.inscription.transition;

import java.util.Collection;
import java.util.Collections;

import de.renew.engine.searcher.Occurrence;
import de.renew.engine.searcher.Searcher;
import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.net.NetInstance;
import de.renew.net.inscription.TransitionInscription;
import de.renew.unify.Impossible;

/**
 * An ExpressionInscription contains an expression that will be evaluated during the search for an active binding.
 */
public class ExpressionInscription implements TransitionInscription {
    static final long serialVersionUID = -411915174051847365L;

    /**
     * The {@code Expression} that will be evaluated during the search for an active binding.
     */
    private final Expression _expression;

    /**
     * Constructs a new ExpressionInscription based on the given {@code Expression}.
     *
     * @param expression the {@code Expression} that will be evaluated during the search for an active binding
     */
    public ExpressionInscription(Expression expression) {
        _expression = expression;
    }

    /**
     * Returns the {@code Expression} that will be evaluated during the search for an active binding.
     *
     * @return the {@code Expression}
     */
    public Expression getExpression() {
        return _expression;
    }

    @Override
    public Collection<Occurrence> makeOccurrences(
        VariableMapper mapper, NetInstance netInstance, Searcher searcher) throws Impossible
    {
        _expression
            .startEvaluation(mapper, searcher.getStateRecorder(), searcher.getCalculationChecker());
        return Collections.emptySet();
    }

    @Override
    public String toString() {
        return "ExpressionInscription: " + _expression;
    }
}